<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
#use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\User;
use App\Models\Subscriber;
use App\Models\SubscriberDepartment;

// Route::get('/user', function (Request $request) {
//     return $request->user();
// })->middleware('auth:sanctum');
Route::post('/subscriber/upload', function (Request $request) {
    try{
        $request->validate(['file' => 'required|file|mimes:jpg,jpeg,png|max:5120',]);// 5MB max
        if (!$request->hasFile('file')) {
            return (object)[
                    'success' => false,
                    'message' => 'No file uploaded'
            ];
        }
        $file = $request->file('file');
        //$fileName = $file->getClientOriginalName();
        //$extension = $file->getClientOriginalExtension();
        ///$fileName = Str::random(20) . '_' . time() . '.' . $extension;
        //$fileSize = $file->getSize();
        //$mimeType = $file->getMimeType();

        // Store file
        $path = $file->store('uploads', 'public');

            // // If it's an image, you can create thumbnail
            // if (strpos($mimeType, 'image/') === 0) {
            //     $thumbnail = Image::make($file)
            //         ->resize(300, 300, function ($constraint) {
            //             $constraint->aspectRatio();
            //         })
            //         ->encode($extension, 80);
                
            //     Storage::disk('public')->put('thumbnails/' . $fileName, $thumbnail);
            // }


            //Storage::delete()
            
            $image_url = Storage::url($path);

            SubscriberDepartment::updateOrCreate(
                [
                    'subscriber_id'=> $request->sid,
                    'department_id'=> $request->did,
                ],
                [
                    'image_url'=> $image_url
                ]
            );

            // Return response
            return (object)[
                    'success' => true,
                    'message' => $image_url
            ];
            // return response()->json([
            //     'success' => true,
            //     'message' => 'File uploaded successfully',
            //     'data' => [
            //         'original_name' => $originalName,
            //         'file_name' => $fileName,
            //         'file_path' => Storage::url($path),
            //         'thumbnail_path' => strpos($mimeType, 'image/') === 0 
            //             ? Storage::url('thumbnails/' . $fileName) 
            //             : null,
            //         'file_size' => $fileSize,
            //         'mime_type' => $mimeType,
            //         'extension' => $extension,
            //     ]
            // ]);
    }catch(\Exception $e){
        return (object)[
                    'success' => false,
                    'message' => $e->getMessage()
            ];
    }
});

Route::post('/subscriber/update', function (Request $data) {
    try{
        $s = Subscriber::find($data->id);
        DB::beginTransaction();
        if($s == null){
            Subscriber::create(
                [
                    'id'=> $data->id,
                    'governorate_id'=> $data->governorate_id,
                    'name'=> $data->name,
                    'logo_url'=> $data->logo_url,
                    'website'=> $data->website,
                    'address'=> $data->address,
                    'description'=> $data->description,
                    'working_days'=> $data->working_days,
                    'additional_fields'=> $data->additional_fields,
                    'department_id'=> $data->department_id,
                    'latitude'=> $data->latitude,
                    'longitude'=> $data->longitude,
                    'user_id'=> $data->user_id,
                    'subscription_status_id'=> '0',
                ]
            );
    } else {
        $s->governorate_id = $data->governorate_id;
        $s->name = $data->name; 
        $s->logo_url = $data->logo_url; 
        $s->website = $data->website; 
        $s->address = $data->address; 
        $s->description = $data->description; 
        $s->working_days = $data->working_days; 
        $s->additional_fields = $data->additional_fields; 
        $s->department_id = $data->department_id; 
        $s->latitude = $data->latitude; 
        $s->longitude = $data->longitude;
        $s->save();
        $old_depts = array_map(function($dept){ return ((object)$dept)->department_id; }, collect(DB::select("select department_id from subscriber_department where subscriber_id='$data->id'"))->toArray());
        $new_depts = array_map(function($dept){ return ((object)$dept)->dept_id; }, $data->departments);        
        $depts = array_diff($old_depts, $new_depts);
        if(count($depts)>0){
            DB::delete("delete from subscriber_department where subscriber_id='$data->id' and department_id in (".implode(",", $depts).")");
        }
    }

    foreach(($data->departments) as $dep){
        $dept =  (object)$dep;
        SubscriberDepartment::updateOrCreate(
            [
                'subscriber_id'=> $data->id,
                'department_id'=> $dept->department_id,
            ],
            [
                'image_url'=> $dept->image_url,
                'description'=> $dept->description,
            ]
        );
    }
        
    DB::commit();
    }catch(\Exception $e){
        try{
            DB::rollBack();
        }catch(\Exception $err){
        }
        return $e->getMessage();
    }
    return '1';
});

Route::get('/subscriber/details', function (Request $request) {
    try{
    return (object) ['data' => Subscriber::find($request->sid)->makeHidden(['subscription_status_id'])->load("departments"), 'rating' => DB::select("select rating from subscriber_rating where subscriber_id='".$request->sid."' and user_id=".$request->uid)[0]->rating ?? "-1"];
    }catch(\Exception $e){
        throw $e;
    }
});

Route::get('/subscriber/rating', function (Request $data) {
    DB::beginTransaction();
    try{
        DB::insert("insert into subscriber_rating(subscriber_id,user_id,rating) values('$data->sid','$data->uid', '$data->score')");
        $res = current((DB::select("select count(rating) as rating_count, avg(rating) as avg_rating from subscriber_rating where subscriber_id='$data->sid'")));
        DB::update("update subscriber set average_rating='". ($res->avg_rating ? round($res->avg_rating, 2) : 0)."',rating_count='".($res->rating_count ?? 0)."' where id='$data->sid'");
        DB::commit();
    }catch(\Exception $e){
        try{
            DB::rollBack();
        }catch(\Exception $err){
        }
        throw $e;
    }
    return $data->score;
});

Route::get('/subscriber/nearby', function (Request $request) {
    try{
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $mainDepts = $request->mainDepts;
        $subDepts = $request->subDepts;
        $cacheKey = "subscribers_nearby_{$request->latitude}_{$request->longitude}_{$mainDepts}_{$subDepts}_";
        
        $data = Cache::remember($cacheKey, 300, function () use ($latitude, $longitude, $mainDepts, $subDepts) {
            $radius = 10;
            $haversine = "(6371 * acos(cos(radians(?)) * cos(radians(latitude)) * 
                      cos(radians(longitude) - radians(?)) + 
                      sin(radians(?)) * sin(radians(latitude))))";
        
            // Calculate bounding box coordinates (approximate 1 degree = 111 km)
            $latDiff = $radius / 111; // Convert radius to latitude degrees
            $lonDiff = $radius / (111 * cos(deg2rad($latitude))); // Convert radius to longitude

            $query = Subscriber::query();
            $query->select([
                'id', 
                'name', 
                'governorate_id',
                'logo_url', 
                'address',
                'working_days',
                'average_rating',
                'rating_count'
            ]);

            // $query->whereNotNull('valid_to');
            // $query->where('valid_to', '>', now());

            $query->selectRaw("{$haversine} AS distance", [$latitude, $longitude, $latitude]);
            $query->whereBetween('latitude', [$latitude - $latDiff, $latitude + $latDiff]);
            $query->whereBetween('longitude', [$longitude - $lonDiff, $longitude + $lonDiff]);
            $query->whereRaw("{$haversine} <= ?", [$latitude, $longitude, $latitude, $radius]);
            
            if($mainDepts != null){
                $query->whereIn('department_id', collect(json_decode('['.$mainDepts.']')));
            }
            else if($subDepts != null){
                $query->whereIn('id', function($query) use($subDepts) {
                    $query->select('subscriber_id')
                        ->from('subscriber_department')
                        ->whereIn('department_id', collect(json_decode('['.$subDepts.']')));
                });
            }

            //$query->whereNotNull('user_id_approvedBy')
            $query->orderBy('distance');
            return $query->get()->makeHidden(['distance'])->load("departments");
        });
        return (object) ['data' => $data->slice(($request->page - 1) * $request->perPage, $request->perPage)->values()->all(), 'pages' => ceil($data->count()/$request->perPage)];
    }catch(\Exception $e){
        throw $e;
    }
    return null;
});

Route::get('/subscriber/deptGovs', function () {
    return Cache::remember('depts_govs_list1', now()->addDays(30), function (){
        return (object)['govs' => DB::select("select id,name from governorate"), 'depts' => DB::select("select id,name,icon,department_id from department")];
    });
});

Route::get('/subscriber/list', function (Request $request) {
    try{
        $govs = $request->govs;
        $mainDepts = $request->mainDepts;
        $subDepts = $request->subDepts;
        $cacheKey = "subscribers_search_{$mainDepts}_{$subDepts}_{$govs}_";
        
        $data = Cache::remember($cacheKey, 300, function () use ($govs, $mainDepts, $subDepts) {
            $query = Subscriber::query();
            $query->select([
                'id', 
                'name', 
                'governorate_id',
                'logo_url', 
                'address',
                'working_days',
                'average_rating',
                'rating_count'
            ]);

            //$query->whereNotNull('valid_to');
            //$query->where('valid_to', '>', now());

            if($govs != null){
                $query->whereIn('governorate_id', collect(json_decode('['.$govs.']')));
            }
            
            if($mainDepts != null){
                $query->whereIn('department_id', collect(json_decode('['.$mainDepts.']')));
            }
            else if($subDepts != null){
                $query->whereIn('id', function($query) use($subDepts) {
                    $query->select('subscriber_id')
                        ->from('subscriber_department')
                        ->whereIn('department_id', collect(json_decode('['.$subDepts.']')));
                });
            }

            //$query->whereNotNull('user_id_approvedBy')
            $query->orderBy('rating_count', 'desc');
            return $query->get()->load("departments");
        });
        return (object) ['data' => $data->slice(($request->page - 1) * $request->perPage, $request->perPage)->values()->all(), 'pages' => ceil($data->count()/$request->perPage)];
    }catch(\Exception $e){
        throw $e;
    }
    return null;
});


Route::get('/subscriber/pay', function (Request $request) {
    try{
        return (object) ['data' => [], 'pages' => 222];
    }catch(\Exception $e){
        throw $e;
    }
    return null;
});

    // $query = User::query();
    
    // // Apply filters
    // if (request()->has('search')) {
    //     $query->where('name', 'like', '%' . request('search') . '%');
    // }
    
    // if (request()->has('status')) {
    //     $query->where('status', request('status'));
    // }