<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('department', function (Blueprint $table) {
            $table->id()->primary();
            $table->string('name');
            $table->string('icon');
            $table->foreignId('department_id')->nullable()->index();
            $table->timestamp("created_at")->useCurrent()->useCurrentOnUpdate();;// default(DB::raw('CURRENT_TIMESTAMP'));
        });

        Schema::create('governorate', function (Blueprint $table) {
            $table->id()->primary();
            $table->string('name');
        });

        Schema::create('subscription_status', function (Blueprint $table) {
            $table->id()->primary();
            $table->string('name');
            $table->timestamp("created_at")->useCurrent()->useCurrentOnUpdate();
        });

        Schema::create('subscriber', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignId('governorate_id');
            $table->string('name');
            $table->string('logo_url')->nullable();
            $table->string('website')->nullable();
            $table->text('address')->nullable();
            $table->text('description')->nullable();
            $table->text('working_days');
            $table->text('additional_fields');
            $table->foreignId('department_id');
            $table->decimal('latitude', total: 15, places: 12)->nullable();
            $table->decimal('longitude', total: 15, places: 12)->nullable();
            $table->foreignId('user_id');
            $table->foreignId('subscription_status_id');
            $table->decimal('average_rating', total: 3, places: 2)->default(0.0);
            $table->integer('rating_count')->default(0);
            $table->foreignId('user_id_approvedBy')->nullable();
            $table->timestamp('valid_to')->nullable();
            $table->timestamp("created_at")->useCurrent();
            $table->timestamp("updated_at")->useCurrent()->useCurrentOnUpdate();
        });

        Schema::create('subscriber_department', function (Blueprint $table) {
            $table->foreignUuid('subscriber_id');
            $table->foreignId('department_id');
            $table->string('image_url')->nullable();
            $table->text('description')->nullable();
            $table->timestamp("created_at")->useCurrent()->useCurrentOnUpdate();
            $table->timestamp("updated_at")->useCurrent()->useCurrentOnUpdate();
            $table->primary(['subscriber_id', 'department_id']);
        });

        Schema::create('subscriber_rating', function (Blueprint $table) {
            $table->foreignUuid('subscriber_id');
            $table->foreignId('user_id');
            $table->decimal('rating', total: 3, places: 2);
            $table->timestamp('created_at')->useCurrent()->useCurrentOnUpdate();
            $table->primary(['subscriber_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriber_rating');
        Schema::dropIfExists('subscriber_department');
        Schema::dropIfExists('subscriber');
        Schema::dropIfExists('subscribtion_status');
        Schema::dropIfExists('governorate');
        Schema::dropIfExists('department');
    }
};
