<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\SubscriberDepartment;

class Subscriber extends Model
{
    protected $table = "subscriber";

    protected $fillable = [
        'id',
        'governorate_id',
        'name',
        'logo_url',
        'website',
        'address',
        'description',
        'working_days',
        'additional_fields',
        'department_id',
        'latitude',
        'longitude',
        'user_id',
        'subscription_status_id',
        'valid_to'
    ];

    protected $casts = [
        'id' => 'string', // This ensures ID is returned as string in JSON
        'average_rating' => 'decimal:2',
        'latitude' => 'decimal:12',
        'longitude' => 'decimal:12',
        'rating_count' => 'integer',
        'governorate_id' => 'integer',
    ];

    protected $keyType = 'string';
    
    public $incrementing = false;

    public $attributes = [];

    protected $hidden = [
        'user_id_approvedBy',
        'created_at',
        'updated_at',
    ];

    
    public function user(){
        return $this->belongsTo('App\Models\User');
    }

    public function departments(){
        return $this->hasMany('App\Models\SubscriberDepartment');
    }
}
